/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: LLDP_Functionlist.h 58013 2015-12-08 07:47:36Z Artem $:

Description:
 LLDP
 Includes structure definitions and prototypes to start LLDP task

Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 2014-10-22    created
**************************************************************************************/
#ifndef __LLDP_FUNCTIONLIST_H
#define __LLDP_FUNCTIONLIST_H

#define LLDP_REM_MIB_VOLUME_DEFAULT                 (10) /* number of complete sets of remote systems'
                                                            information in the remote MIB */
#define LLDP_NUMBER_OF_PORTS_DEFAULT                (2)  /* maximum number of available ports */
#define LLDP_NUMBER_OF_MAN_ADDR_DEFAULT             (10) /* supported number of management addresses describing either the local
                                                            system information or remote system information */
#define LLDP_NUMBER_OF_VLAN_NAME_DEFAULT            (3)  /* number of supported Vlan Name TLVs */
#define LLDP_NUMBER_OF_PPVID_DEFAULT                (3)  /* number of supported PPVID TLVs */
#define LLDP_NUMBER_OF_PID_DEFAULT                  (3)  /* number of supported PID TLVs */
#define LLDP_NUMBER_OF_UNKNOWN_DEFAULT              (5)  /* number of supported unrecognized TLVs */
#define LLDP_MAX_NUM_OF_REM_SYS_MIB_ENTRIES_DEFAULT (2)  /* max number of entries in the remote systems MIB  */

/***************************************************************************************/
/* LLDP  function list, prototypes */

TLR_RESULT  TaskExit_LLDP (TLR_VOID FAR* pvRsc);

TLR_RESULT  TaskLeave_LLDP(TLR_VOID FAR* pvRsc,
                                             TLR_VOID FAR* pvLve);

TLR_RESULT  TaskEnter_LLDP(TLR_VOID FAR* pvInit);

#define LLDP_STARTUP_PARAM_VERSION_5 (5)

typedef struct LLDP_STARTUPPARAMETER_Ttag
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;

  /* number of entries in remote systems MIB */
  TLR_UINT    uiRemoteMibElemMax;
  /* number of ports max */
  TLR_UINT    uiPortsNum;
  /* max number of management addresses for either local or remote system information entry */
  TLR_UINT    uiManAddrNum;
  /* max number of XDOT1 Vlan Names for either local or remote system information entry */
  TLR_UINT    uiVlanNameNum;
  /* max number of XDOT1 PPVIDs for either local or remote system information entry */
  TLR_UINT    uiPpvidNum;
  /* max number of XDOT1 PIDs for either local or remote system information entry */
  TLR_UINT    uiPidNum;
  /* max number of either basic set unknown TLVs or extension set unknown
     TLVs for either local or remote system information entry */
  TLR_UINT    uiUnknownNum;
  /* name of EDD to identify*/
  TLR_STR*   pszEddName;
  /* name of PHY 0 to identify, no longer used for LLDP > v4.2.x.x */
  TLR_STR*   pszPhy0Name;
  /* name of PHY 1 to identify, no longer used for LLDP > v4.2.x.x  */
  TLR_STR*   pszPhy1Name;
  /* instance of DrvEdd to identify */
  TLR_UINT   uiEddInstance;
  /* instance of Phy0 to identify, no longer used for LLDP > v4.2.x.x */
  TLR_UINT   uiPhy0Instance;
  /* instance of Phy1 to identify, no longer used for LLDP > v4.2.x.x */
  TLR_UINT   uiPhy1Instance;

  /* NwC mode: true: use network control priority for sending LLDP, false: use default NRT priority */
  /* Note: ONLY use NwC mode if XC code supports this (e.g. Profinet cut through switch) */
  /* introduced in startup structure version 5 */
  TLR_BOOLEAN fUseNwCMode;
} LLDP_STARTUPPARAMETER_T_V5;


/***************************************************************************************/
#endif /* #ifndef __LLDP_FUNCTIONLIST_H */

